<%'
' This method queries the user's fax log by calling the FaxQuery() method.
' A typical usage would be to get the information about a given transaction. This is done by specifying
' Verb as "EQ" and VerbData as the transaction ID.
'
' For extended query capabilities, use the FaxQuery2() method.
'
Option Explicit
%><!-- #include file = "Utils.asp" --><%

Const Verb = "GE"
Const VerbData = "1000000"
Const MaxItems = 10

Dim i , j
Dim strOut

Dim objEnv
Dim objHttp

Set objEnv = Server.CreateObject("PocketSOAP.Envelope")

objEnv.EncodingStyle = ""

objEnv.SetMethod "FaxQuery", "http://www.interfax.cc"
objEnv.Parameters.Create "Username", Username, objEnv.URI
objEnv.Parameters.Create "Password", Password, objEnv.URI
objEnv.Parameters.Create "Verb", Verb, objEnv.URI
objEnv.Parameters.Create "VerbData", VerbData, objEnv.URI
objEnv.Parameters.Create "MaxItems", MaxItems, objEnv.URI
objEnv.Parameters.Create "ResultCode", 0, objEnv.URI   ' this is the In/Out parameter

Set objHttp = Server.CreateObject("PocketSOAP.HTTPTransport")
objHttp.SoapAction = "http://www.interfax.cc/FaxQuery"
objHttp.Send "http://ws.interfax.net/DFS.asmx", objEnv.Serialize
objEnv.parse objHttp

Dim ResultCode 'of type PocketSOAP.CoSoapNode
Set ResultCode = objEnv.Parameters.itemByName("ResultCode", objEnv.URI)

If ResultCode.Value <> 0 Then
    response.write ("Bad status=" & ResultCode.Value)
    response.End
End If

Dim FaxQueryResult 'of type PocketSOAP.CoSoapNode
Set FaxQueryResult = objEnv.Parameters.itemByName("FaxQueryResult", objEnv.URI)

Dim FaxItemEx 'of type PocketSOAP.CoSoapNode
For i = 0 To FaxQueryResult.Nodes.Count - 1
    Set FaxItemEx = FaxQueryResult.Nodes.Item(i).Value
    strOut = "<hr>"
    For j = 0 To FaxItemEx.Nodes.Count - 1
        strOut = strOut & FaxItemEx.Nodes.Item(j).Name & ": " & FaxItemEx.Nodes.Item(j).Value & "<BR>"
    Next
    response.write strOut
Next

Set objEnv = Nothing
Set objHttp = Nothing
%>