<%'
' This method retrieves the image of a fax from the Outbound service by calling the FaxQuery() method.
' The retrieved data is than saved to a local file
'
Option Explicit
%><!-- #include file = "Utils.asp" --><%

Const TransactionID = 129040055
' Make sure you have write access permission to the specified path
Dim FileName : FileName = "c:\temp\" & TransactionID & ".TIF"

Dim ReturnCode
Dim B

Dim objEnv
Dim objHttp

Set objEnv = Server.CreateObject("PocketSOAP.Envelope")
objEnv.EncodingStyle = ""
objEnv.SetMethod "GetFaxImage", "http://www.interfax.cc"
objEnv.SerializerFactory.ElementMapping "buffer", "", "base64Binary", ""
Set objHttp = Server.CreateObject("PocketSOAP.HTTPTransport")
objHttp.SoapAction = "http://www.interfax.cc/GetFaxImage"
'
' Returns a chunck of data. Also returns the actual size of the returned data
'
objEnv.Parameters.Create "Username", Username, objEnv.URI
objEnv.Parameters.Create "Password", Password, objEnv.URI
objEnv.Parameters.Create "TransactionID", TransactionID, objEnv.URI

objHttp.Send "http://ws.interfax.net/DFS.asmx", objEnv.Serialize
objEnv.EncodingStyle = ""
objEnv.parse objHttp

Dim GetFaxImageResult 'of type PocketSOAP.CoSoapNode
Set GetFaxImageResult = objEnv.Parameters.itemByName("GetFaxImageResult", objEnv.URI)

If GetFaxImageResult.Value <> 0 Then
    response.write ("Bad status=" & GetFaxImageResult.Value)
    response.End
End If

Dim Image 'of type PocketSOAP.CoSoapNode
Set Image = objEnv.Parameters.itemByName("Image", objEnv.URI)
'
' The SOAP engine seems to not properly handle the returned value, which is Base64-encoded.
' Thus a decoding is done by the DecodeBase64 method.
'
If Not DecodeBase64(Image.Value, B) Then
    response.write "Could not get or decode buffer"
    response.End
End If

' Save to file
WriteBinaryFile FileName, B
response.write "Saved as " & FileName

Set objEnv = Nothing
Set objHttp = Nothing
%>