<%
Option Explicit
%><!-- #include file = "Utils.asp" --><%
'
' This sample gets an entire message from the Inbound queue and saves it to a local file.
' Message is being retrieved in chunks, to optimize performance.
' A typical usage would be to call this method for each item retreived by the GetList2() method
'
Const MessageID = 30586053   ' Specify ID of message to be retrieved to get it
Const ChunkSize = 10000   '10KB per request
Dim OutputFileName : OutputFileName = "c:\temp\" & MessageID & ".PDF"    'Path of local file
'
' Loop until no more data
'
Dim lngReturnedSize
Dim lngStartFrom : lngStartFrom = 0
Dim Chunk
Dim Buffer

Do While True
	GetChunk lngStartFrom, Chunk
	if VarType(Chunk)<8192 then exit do	' not an array - indicates end of chuncks
    Buffer = ConcatByteArrays(Buffer, Chunk)
    lngStartFrom = lngStartFrom + UBound(Chunk) + 1
    response.write "Received so far: " & CStr(lngStartFrom) & " bytes <BR>"
Loop

WriteBinaryFile OutputFileName, Buffer
response.write "Saved as " & OutputFileName

Function GetChunk( From ,  Chunk)

Dim objEnv
Dim objHttp

Set objEnv = Server.CreateObject("PocketSOAP.Envelope")
objEnv.EncodingStyle = ""
objEnv.SetMethod "GetImageChunkEx2", "http://www.interfax.net"
objEnv.SerializerFactory.ElementMapping "buffer", "", "base64Binary", ""
Set objHttp = Server.CreateObject("PocketSOAP.HTTPTransport")
objHttp.SoapAction = "http://www.interfax.net/GetImageChunkEx2"

objEnv.Parameters.Create "Username", Username, objEnv.URI
objEnv.Parameters.Create "Password", Password, objEnv.URI
objEnv.Parameters.Create "MessageID", MessageID, objEnv.URI
objEnv.Parameters.Create "MarkAsRead", False, objEnv.URI
objEnv.Parameters.Create "ChunkSize", ChunkSize, objEnv.URI
objEnv.Parameters.Create "From", From, objEnv.URI

objHttp.Send "http://ws.interfax.net/Inbound.asmx", objEnv.Serialize
objEnv.EncodingStyle = ""
objEnv.parse objHttp

Dim Result ' of tupe PocketSOAP.CoSoapNode
Set Result = objEnv.Parameters.Item(0)  'entire response

Dim ResultCode 'of type PocketSOAP.CoSoapNode
Set ResultCode = Result.Nodes.itemByName("ResultCode", objEnv.URI)
if ResultCode.Value <> 0 then
	response.write "Bad ResultCode=" & ResultCode.Value
	response.end
End If

Dim SourceFileType 'of type PocketSOAP.CoSoapNode
Set SourceFileType = Result.Nodes.itemByName("SourceFileType", objEnv.URI)

Dim Buffer 'of type PocketSOAP.CoSoapNode
Set Buffer = Result.Nodes.itemByName("buffer", objEnv.URI)

' Decoding is done at the application level, as PowerSoap does not seem to de-serialize the response.
GetChunk = DecodeBase64(Buffer.Value, Chunk)

Set objEnv = Nothing
Set objHttp = Nothing

End Function
%>