<%
'
' This method gets a list of received faxes from the Inbound queue.
' A typical usage would be:
' ~ retrieve a list of all only new (yet Unread) items.
' ~ Browse the list and for each item on it:
'       Fetch the Image (tiff or pdf) using the GetList2() method
'       Mark each retrieved item as 'Read' using the MarkMessage() method
'
Option Explicit
%><!-- #include file = "Utils.asp" --><%

Const TransactionID = 0   'All Transactions; Specify ID to get it

Dim objEnv
Dim objHttp

Set objEnv = Server.CreateObject("PocketSOAP.Envelope")

objEnv.EncodingStyle = ""

objEnv.SetMethod "GetList2", "http://www.interfax.net"
objEnv.Parameters.Create "Username", Username, objEnv.URI
objEnv.Parameters.Create "Password", Password, objEnv.URI
' Start a QueryForm
Dim QF 'of type PocketSOAP.CoSoapNode
Set QF = objEnv.Parameters.Create("QueryForm", Empty, objEnv.URI)
QF.Nodes.Create "TransactionID", TransactionID, objEnv.URI
QF.Nodes.Create "UserID", "", objEnv.URI 'query about me as a user
QF.Nodes.Create "OnlyNewMessages", True, objEnv.URI 'Messages that are not marked as 'read'

Dim RT 'of type PocketSOAP.CoSoapNode
Set RT = QF.Nodes.Create("RecieveTime", Empty, objEnv.URI)  'Head of block
RT.Nodes.Create "Verb", "", objEnv.URI 'query about me as a user
RT.Nodes.Create "VerbData", "", objEnv.URI 'query about me as a user

Dim QC 'of type PocketSOAP.CoSoapNode
Set QC = objEnv.Parameters.Create("QueryControl", Empty, objEnv.URI)
QC.Nodes.Create "MaxChunkSize", 10000, objEnv.URI
QC.Nodes.Create "FromRecordNumber", 0, objEnv.URI

Set objHttp = Server.CreateObject("PocketSOAP.HTTPTransport")
objHttp.SoapAction = "http://www.interfax.net/GetList2"
objHttp.Send "http://ws.interfax.net/Inbound.asmx", objEnv.Serialize
objEnv.parse objHttp

Dim Result 'of type PocketSOAP.CoSoapNode
Set Result = objEnv.Parameters.Item(0)

Dim ResultCode 'of type PocketSOAP.CoSoapNode
Set ResultCode = Result.Nodes.itemByName("ResultCode", objEnv.URI)
response.write "ResultCode=" & ResultCode.Value & "<br>"

Dim TotalTransactionsNum 'of type PocketSOAP.CoSoapNode
Set TotalTransactionsNum = Result.Nodes.itemByName("TotalTransactionsNum", objEnv.URI)
Dim n : n = TotalTransactionsNum.Value
response.write "TotalTransactionsNum=" & n & " (showing first 5)" & "<br>"
If n > 5 Then n = 5

Dim i , j
If n > 0 Then
    Dim MessageItems 'of type PocketSOAP.CoSoapNode
    Set MessageItems = Result.Nodes.itemByName("MessageItems", objEnv.URI)
    response.write "Items: " & MessageItems.Nodes.Count & "<br>"
    Dim MessageItem2 'of type PocketSOAP.CoSoapNode
    Dim strOut
    For i = 0 To n - 1
        Set MessageItem2 = MessageItems.Nodes.Item(i)
        strOut = "<hr>"
        For j = 0 To MessageItem2.Nodes.Count - 1
            strOut = strOut & MessageItem2.Nodes.Item(j).Name & ": " & MessageItem2.Nodes.Item(j).Value & "<br>"
        Next
        response.write strOut
    Next
End If

Set objEnv = Nothing
Set objHttp = Nothing
%>