<%
'
' This method sends 2 documents to 2 fax destinations
'
Option Explicit
%><!-- #include file = "Utils.asp" --><%

' Prepare fax numbers
Const FaxNumbers = "+12125551212;+442075554321"
'
'Read data from a file to a byte-array
'
Const FilenametoFax_1 = "c:\temp\1.pdf"
Dim B1
B1 = ReadBinaryFile(FilenametoFax_1)
Dim Len1 : Len1 = UBound(B1) + 1
Dim DataSize : DataSize = CStr(Len1)
Dim FileType : FileType = "pdf"

' In case additional file(s) are required, add them
Const FilenametoFax_2 = "c:\temp\1.doc"
Dim B2
B2 = ReadBinaryFile(FilenametoFax_2)
Dim Len2 : Len2 = UBound(B2) + 1

' And combine the 2 buffers
Dim B : B = ConcatByteArrays(B1, B2)

' Set parameters to reflect multiple documents
DataSize = DataSize & ";" & CStr(Len2)
FileType = FileType & ";" & "doc"

'Invoke the Interfax method
Dim SendFaxResult
Dim objEnv
Dim objHttp

Set objEnv = Server.CreateObject("PocketSOAP.Envelope")

objEnv.EncodingStyle = ""

objEnv.SetMethod "SendfaxEx_2", "http://www.interfax.cc"
objEnv.Parameters.Create "Username", Username, objEnv.URI
objEnv.Parameters.Create "Password", Password, objEnv.URI
objEnv.Parameters.Create "FaxNumbers", FaxNumbers, objEnv.URI
objEnv.Parameters.Create "Contacts", "", objEnv.URI
objEnv.Parameters.Create "FilesData", EncodeBase64(B), objEnv.URI
objEnv.Parameters.Create "FileTypes", FileType, objEnv.URI
objEnv.Parameters.Create "FileSizes", DataSize, objEnv.URI
objEnv.Parameters.Create "Postpone", DateAdd("d", -1, Now()), objEnv.URI 'any time in the past for sending ASAP
objEnv.Parameters.Create "RetriesToPerform", 3, objEnv.URI
objEnv.Parameters.Create "CSID", "MyCSID", objEnv.URI
objEnv.Parameters.Create "PageHeader", "", objEnv.URI
objEnv.Parameters.Create "JobID", "", objEnv.URI
objEnv.Parameters.Create "Subject", "Fax Subject", objEnv.URI
objEnv.Parameters.Create "ReplyAddress", "myaddress@mydocom", objEnv.URI
objEnv.Parameters.Create "PageSize", "Letter", objEnv.URI
objEnv.Parameters.Create "PageOrientation", "Landscape", objEnv.URI
objEnv.Parameters.Create "IsHighResolution", False, objEnv.URI
objEnv.Parameters.Create "IsFineRendering", False, objEnv.URI

Set objHttp = Server.CreateObject("PocketSOAP.HTTPTransport")
objHttp.SoapAction = "http://www.interfax.cc/SendfaxEx_2"
objHttp.Send "http://ws.interfax.net/DFS.asmx", objEnv.Serialize
objEnv.parse objHttp

Dim SendResult
SendResult = objEnv.Parameters.Item(0).Value

'Analyze the response
If SendResult > 0 Then
    response.write "Fax submitted. Parent transaction ID: " & SendResult
Else
    response.write "Error sending fax. Return code: " & SendResult
End If
%>